<?php
/**
 * Element: Templates File
 *
 * @package    Modalizer
 * @version    1.2.3
 * @since      File available since Release 1.0.5
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl/modalizer
 * @copyright  Copyright (C) 2008 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// Ensure this file is being included by a parent file
defined('_JEXEC') or die( 'Restricted access' );

class JElementTemplates extends JElement {
	/**
	 * Element name
	 *
	 * @access	protected
	 * @var		string
	 */
	var	$_name = 'Templates';

	function fetchElement($name, $value, &$node, $control_name) {

		$client	=& JApplicationHelper::getClientInfo(JRequest::getVar('client', '0', '', 'int'));
		JLoader::import('administrator.components.com_templates.helpers.template',$client->path);
		$templateBaseDir = $client->path.DS.'templates';
		$rows = array();
		$rows = TemplatesHelper::parseXMLTemplateFiles($templateBaseDir);
		$options = $this->createList($rows, $templateBaseDir);

		$list 	= JHTML::_('select.genericlist', $options, ''.$control_name.'['.$name.']', 'class="inputbox" size="'.count($options).'"', 'value', 'text', $value, $control_name.$name );

		return $list;
	}
	function createList($rows, $templateBaseDir) {
		$options = array();

		$option = null;
		$option->value = ':';
		$option->text = 'Default';
		$option->disable = null;
		$options[] = $option;

		$option = null;
		$option->value = 'system:component';
		$option->text = 'None (System - component)';
		$option->disable = null;
		$options[] = $option;

		$option = null;
		$option->value = '0';
		$option->text = '&nbsp;';
		$option->disable = 1;
		$options[] = $option;

		foreach ( $rows as $row ) {

			$option = null;
			$option->value = $row->directory;
			$option->text = $row->name;
			$option->disable = null;
			$options[] = $option;

			$options_sub = $this->getSubTemplates($row, $templateBaseDir);
			$options = array_merge($options,$options_sub);
		}
		return $options;
	}

	function getSubTemplates($row, $templateBaseDir) {
		$options = array();
		$templateDir = dir($templateBaseDir.DS.$row->directory);
		while ( false !== ($file = $templateDir->read()) ) {
		  	if ( is_file($templateDir->path.DS.$file) ) {
				if ( !(strpos($file,'.php') === false) && $file != 'index.php') {
					$file_name = str_replace('.php','',$file);
					if ( $file_name != 'index' && $file_name != 'error' ) {
						$option = null;
						$option->value = $row->directory.':'.$file_name;
						$option->text = $row->name.' - '.$file_name;
						$option->disable = null;
						$options[] = $option;
					}
				}
			}
		}
		$templateDir->close();

		return $options;
	}
}