<?php
/** ****************************************************************
 * This file is part of SecurityImages for Joomla!.
 *
 * SecurityImages is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.

 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package		SecurityImages
 * @copyright	Copyright (C) 2004 - 2008 Cdric Walter. All rights reserved.
 *******************************************************************/

defined( '_JEXEC' ) or die( 'Restricted access' );

class SecurityImagesCalculator extends JObject  {

  var $number1 = null;
  var $number2 = null;
  var $operatorString = null;
  var $result = null;

  var $red = null;
  var $blue = null;
  var $green = null;


  /**
   * Enter description here...
   *
   * @return SecurityImagesCalculator
   */
  function SecurityImagesCalculator() {
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'pluginsA'.DS.'calculator'.DS.'1.0'.DS.'config.php');
    
    $this->number1 = rand($si_calculator_firstNumberMin, $si_calculator_firstNumberMax);
    $this->number2 = rand($si_calculator_secondNumberMin, $si_calculator_secondNumberMax);
    $operator = rand(1, 2);

    if ($operator == "1")
    {
      $this->operatorString = " + ";
      $this->result = $this->number1 + $this->number2;
    } else
    {
      $this->operatorString = " - ";
      $this->result = $this->number1 - $this->number2;
    }

    $this->red = null;
    $this->blue = null;
    $this->green = null;
  }

  /**
   * Enter description here...
   *
   * @param unknown_type $string
   * @param unknown_type $key
   * @return unknown
   */
  function encrypt($string, $key)
  {
    $result = '';
    for ($i = 0; $i < strlen($string); $i++)
    {
      $char = substr($string, $i, 1);
      $keychar = substr($key, ($i % strlen($key)) - 1, 1);
      $char = chr(ord($char) + ord($keychar));
      $result .= $char;
    }
    return str_replace("=", "", base64_encode($result));
  }

  /**
   * Enter description here...
   *
   * @param unknown_type $min
   * @param unknown_type $max
   */
  function getRandomColor($min, $max) {
     
    srand((double) microtime() * 1000000);
    $this->red = intval(rand($min, $max));
    srand((double) microtime() * 1000000);
    $this->green = intval(rand($min, $max));
    srand((double) microtime() * 1000000);
    $this->blue = intval(rand($min, $max));
  }


  /**
   * Enter description here...
   *
   * @param unknown_type $image
   */
  function outputImage($image)
  {
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'pluginsA'.DS.'calculator'.DS.'1.0'.DS.'config.php');

    switch ($si_calculator_securityImagesoutput)
    {
      case "jpg" :
        header("Content-Type: image/jpeg");
        ImageJPEG($image);
        break;
      case "gif" :
        header("Content-Type: image/gif");
        ImageGIF($image);
        break;
      case "png" :
      default :
        header("Content-Type: image/png");
        ImagePNG($image);
        break;
    }
    imagedestroy($image);
  }


  /**
   * Enter description here...
   *
   */
  function getCaptcha() {
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'pluginsA'.DS.'calculator'.DS.'1.0'.DS.'config.php');
    
    
    $session =& JFactory::getSession();
    $session->set('publicKey',$this->result);
    $session->set('hnkey',$si_calculator_secretKey);
    $session->set('privateKey',$si_calculator_secretKey);

    $testDisplayed = $this->number1 . $this->operatorString . $this->number2 . " = ?";
    $image = imagecreatetruecolor($si_calculator_xSize, $si_calculator_ySize);

    //random text color
    $this->getRandomColor($si_calculator_RGBmin, $si_calculator_RGBmax);
    $textColor = ImageColorAllocate($image, $this->red, $this->green, $this->blue);

    //random background color
    $this->getRandomColor($si_calculator_BKG_RGBmin, $si_calculator_BKG_RGBmax);
    $background = ImageColorAllocate($image, $this->red, $this->green, $this->blue);
    imagefill($image, 0, 0, $background);

    imagestring($image, $si_calculator_fontSize, 2, 0, $testDisplayed, $textColor);
    $this->outputImage($image);
  }

}
?>