<?php
/** ****************************************************************
 * This file is part of SecurityImages for Joomla!.
 *
 * SecurityImages is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.

 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package		SecurityImages
 * @copyright	Copyright (C) 2004 - 2008 Cdric Walter. All rights reserved.
 *******************************************************************/

defined( '_JEXEC' ) or die( 'Restricted access' );

class SecurityImageSystemInfo extends JObject {

  function SecurityImageSystemInfo() {

  }

  function isGDInstalled() {
    if (function_exists('imagecreatetruecolor'))
    return true;

    return false;
  }

  /**
   * Enter description here...
   *
   */
  function checkSystem() {
    echo "<table border='2' align='center'>";
    echo "<tr><td colspan='2'><b>".JText::_('TRY_TO_DETECT')."<br></b></td></tr>";
    echo "<tr><td colspan='2'>";
    if ($this->isGDInstalled())
    echo "<font color='green'>".JText::_('GD_IS_INSTALLED')."</font>";
    else {
      echo "<font color='red'>".JText::_('GD_NOT_INSTALLED')."</font><br>";
      echo JText::_('GD_NOT_INSTALLED1');
      echo JText::_('GD_NOT_INSTALLED2');
      echo "<br />";
      echo JText::_('GD_NOT_INSTALLED3');
      echo JText::_('GD_NOT_INSTALLED4');
      echo JText::_('GD_NOT_INSTALLED5');
      echo JText::_('GD_NOT_INSTALLED6');
      echo JText::_('GD_NOT_INSTALLED7');
    }
    echo "</td></tr>";

    echo "<tr><td colspan='2'>";
    if (function_exists('ImageJPEG')) {
      echo "<font color='green'>".JText::_('GD_HAS_JPG')."</font>";
    } else
    {
      echo "<font color='red'>".JText::_('GD_HAS_NO_JPG')."</font>";
    }
    echo "</td></tr>";


    echo "<tr><td colspan='2'>";
    if (function_exists('ImagePNG')) {
      echo "<font color='green'>".JText::_('GD_HAS_PNG')."</font>";
    } else
    {
      echo "<font color='red'>".JText::_('GD_HAS_NO_PNG')."</font>";
    }
    echo "</td></tr>";

    echo "<tr><td colspan='2'>";
    if (function_exists('ImageGIF')) {
      echo "<font color='green'>".JText::_('GD_HAS_GIF')."</font>";
    } else
    {
      echo "<font color='red'>".JText::_('GD_HAS_NO_GIF')."</font>";
    }
    echo "</td></tr>";
     
    echo "<tr><td colspan='2'>";
    echo "<font color='black'>".JText::_('SYSTEM_HAS_SYSTEM_PLUGIN1')."</font><br />";
    if (file_exists(JPATH_SITE.DS.'plugins'.DS.'system'.DS.'securityimages.php')) {
      echo "<font color='green'>".JText::_('SYSTEM_HAS_SYSTEM_PLUGIN2')."</font>";
    } else
    {
      echo "<font color='red'>".JText::_('SYSTEM_HAS_SYSTEM_PLUGIN3')."</font>";
    }
    echo "</td></tr>";


    //Check that plugin has been deployed
    echo "<tr><td colspan='2'>";
    echo "<font color='black'>".JText::_('SYSTEM_HAS_SYSTEM_PLUGIN_PUBLISHED')."</font><br />";
    
    $database = & JFactory::getDBO();
    $database->setQuery("SELECT published FROM #__plugins where element='securityimages'");
      
    if (($isPluginPublished=(int)$database->loadResult())>0) {
      echo "<font color='green'>".JText::_('SYSTEM_HAS_SYSTEM_PLUGIN_PUBLISHED_YES')."</font>";
    } else
    {
      echo "<font color='red'>".JText::_('SYSTEM_HAS_SYSTEM_PLUGIN_PUBLISHED_NO')."</font>";
    }
    echo "</td></tr>";
     
    echo "<tr><td colspan='2'><b>".JText::_('TESTING_ALL_PLUGIN')."</b></td></tr>";

    echo "<tr><td>Freecap</td><td><img src='".JURI :: root()."index.php?option=com_securityimages&task=displayCaptchaByPlugin&plugin=freecap&version=1.4' id='freecap_image'/></td></tr>";

    echo "<tr><td>Core</td><td><img src='".JURI :: root()."index.php?option=com_securityimages&task=displayCaptchaByPlugin&plugin=core&version=1.1' id='core_image'/></td></tr>";

    echo "<tr><td>Hncaptcha</td><td><img src='".JURI :: root()."index.php?option=com_securityimages&task=displayCaptchaByPlugin&plugin=hncaptcha&version=1.0' id='hncaptcha_image'/></td></tr>";

    echo "<tr><td>Watercap</td><td><img src='".JURI :: root()."index.php?option=com_securityimages&task=displayCaptchaByPlugin&plugin=watercap&version=1.0' id='watercap_image'/></td></tr>";

    echo "<tr><td>Calculator</td><td><img src='".JURI :: root()."index.php?option=com_securityimages&task=displayCaptchaByPlugin&plugin=calculator&version=1.0' id='calculator_image'/></td></tr>";

    echo "<tr><td>Recaptcha</td><td>";
    
    $test = JURI :: root()."index.php?option=com_securityimages&task=onSecurityImagesRecaptchaDisplay";
    echo $test;
    echo "</td></tr>";

    echo "<tr><td colspan='2'><b><font color='black'>".JText::_('SYSTEM_CHECK_JOOMLA_PATCHES')."</font></b></td></tr>";
    
    $joomlapatchesAreActive = false;
    $usersConfig = &JComponentHelper::getParams( 'com_users' );
    if ($usersConfig->get( 'useSecurityImages' )) {
      $joomlapatchesAreActive = true;
    }
     
    //Check that plugin has been deployed
    echo "<tr><td colspan='2'>";
    echo "<font color='black'>".JText::_('SYSTEM_CHECK_SAVE_JOOMLA_CONFIG')."</font><br />";
    if ($joomlapatchesAreActive) {
      echo "<font color='green'>".JText::_('SYSTEM_CHECK_SAVE_JOOMLA_CONFIG_OK')."</font>";
    } else
    {
      echo "<font color='red'>".JText::_('SYSTEM_CHECK_SAVE_JOOMLA_CONFIG_NO')."</font>";
    }
    echo "</td></tr>";
     
    if ($joomlapatchesAreActive) {
      echo "<tr>";
      echo "<td colspan='2'>".JText::_('SYSTEM_CHECK_JOOMLA_CONTACT')."<br /><img src='".JURI :: root()."/index.php?option=com_contact&task=displaySecurityImagesCaptcha&contact_id=1' /></td>";
      echo "</tr>";

      echo "<tr>";
      echo "<td colspan='2'>".JText::_('SYSTEM_CHECK_JOOMLA_REGISTER')."<br /><img src='".JURI :: root()."/index.php?option=com_user&task=displaySecurityImagesCaptcha' /></td>";
      echo "</tr>";

      echo "<tr>";
      echo "<td colspan='2'>".JText::_('SYSTEM_CHECK_JOOMLA_LOST_PASSWORD')."<br /><img src='".JURI :: root()."/index.php?option=com_user&view=reset&task=displaySecurityImagesCaptcha' /></td>";
      echo "</tr>";

      echo "<tr>";
      echo "<td colspan='2'>".JText::_('SYSTEM_CHECK_JOOMLA_LOST_USER')."<br /><img src='".JURI :: root()."/index.php?option=com_user&view=remind&task=displaySecurityImagesCaptcha' /></td>";
      echo "</tr>";
    }

    echo "</table>";
  }
}
?>