<?php
/**
 * VersionCheck Include File
 * Checks if current version is the latest
 *
 * @package    Joomla version check
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl
 * @copyright  Copyright (C) 2009 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// Ensure this file is being included by a parent file
defined('_JEXEC') or die( 'Restricted access' );

/**
 * Version Check Class (Include file)
 */
class jvcVersionCheck
{
	function check( $version_file = '', $version_path = '', $version_url = '' )
	{
		$version = array( '', '' );
		if ( $version_file ) {
                    //get current Joomla version
                    $Jversion = new JVersion();
                    $version[0] = $Jversion->getShortVersion();

                    $version[0] = explode('.',$version[0]);
                    if ($version[0][2] <= '9'){$version[0][2] = '0'.$version[0][2];}
                    $version[0]=$version[0][0].'.'.$version[0][1].'.'.$version[0][2];


                    $version[1] = $Jversion->getShortVersion();
					// the url of the new version file
					$_new_version_url	= $version_url.'/'.$version_file.'.txt';
                    // open the new version file
					$_new_version_file = @fopen( $_new_version_url, 'r' );
					if ( !$_new_version_file ) {
						// the given version_url is not found, so is probably a file and not a folder
						// so try to find the file in the folder
						// the url of the new version file
						$_new_version_url	= $version_url;
						// open the new version file
						$_new_version_file = @fopen( $_new_version_url, 'r' );
					}
					if ( $_new_version_file ) {
						// read the contents of the new version files (10 chars must be enough)
						$_new_version = jvcVersionCheck::cleanString( fread( $_new_version_file, 10 ) );
						$version[1] = $_new_version;
					}
		}
		// return false
		return $version;
	}
	function setMessage( $version_file = '', $version_path = '', $version_url = '', $download_url = '' )
	{
		$messageQueue = $this->getMessageQueue();

		if ( $version_file && !$messageQueue ) {
			$_version = jvcVersionCheck::check( $version_file, $version_path, $version_url );
			$_current_version = $_version[0];
			$_new_version = $_version[1];
			if ( $_current_version < $_new_version ) {
				// set message
				$_msg = JText::sprintf( 'A newer version is available', $download_url, $_new_version, $_new_version );
				$this->enqueueMessage( $_msg, 'notice' );
			}
		}
	}
	function getMessage( $version_file = '', $version_path = '', $version_url = '', $download_url = '' )
	{
		$msg = '';
		if ( $version_file ) {
			$_version = jvcVersionCheck::check( $version_file, $version_path, $version_url );
			$_current_version = $_version[0];
			$_new_version = $_version[1];
			if ( $_current_version && $_current_version < $_new_version ) {
				// set message
				$msg = '<div id="system-message"><dd class="notice"><ul><li>';
				$msg .= JText::sprintf( 'A NEWER VERSION IS AVAILABLE', $download_url, $_new_version, $_new_version );
				$msg .= '</li></ul></dd></div>';
			}
		}
		return $msg;
	}

	function setIcon( $html, $version_file = '', $version_path = '', $version_url = '', $download_url = '', $icon_url = '', $target = '_blank' )
	{
		if ( $version_file ) {
			$_version = jvcVersionCheck::check( $version_file, $version_path, $version_url );
			$_current_version = $_version[0];
			$_new_version = $_version[1];
			if ( $_current_version && $_current_version < $_new_version ) {
				if ($target==''){
					$_tooltip = JText::sprintf( 'TIP: UPGRADE TO NEW VERSION', $_new_version );
				} else {
					$_tooltip = JText::sprintf( 'TIP: DOWNLOAD NEW VERSION', $_new_version );
				}
				if ( $_tooltip != 'TIP: A NEWER VERSION IS AVAILABLE' ) {
					$_s = '<div id="module-status">';
					$_r = '<div id="module-status"><span style="padding-left: 2px;background: none;"><label class="hasTip" title="'.$_tooltip.'"><a href="'.$download_url.'" target="'.$target.'"><img width="16" height="16" src="'.$icon_url.'"></a></label></span>';
					$html = str_replace( $_s, $_r, $html );
				}
			}
		}
		return $html;
	}

	function cleanString( $str = '' )
	{
		$str = preg_replace( '#[^0-9\.]#', '', $str );
		return $str;
	}
}
?>