<?php
/** ****************************************************************
 * This file is part of SecurityImages for Joomla!.
 *
 * SecurityImages is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.

 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package		SecurityImages
 * @copyright	Copyright (C) 2004 - 2008 Cdric Walter. All rights reserved.
 *******************************************************************/
defined( '_JEXEC' ) or die( 'Restricted access' );


require_once(dirname( __FILE__ ).DS.'logUtils.php' );
require_once(dirname( __FILE__ ).DS.'systeminfo.php' );
jimport('joomla.error.log');

class SecurityImagesHelper extends JOBject {

  function SecurityImagesHelper() {

  }

  /**
   * Enter description here...
   *
   * @param unknown_type $userTry
   */
  function checkSecurityImageUserTry ($userTry) {
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'config.securityimages.php');
    include_once (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'pluginsA'.DS.$securityImagesPlugins.DS.$securityImagesPluginsVersion.DS.'checker.php');

    if ($this->isSecurityImageActive()) {
      if ($securityImagesRegressionTestMode && ($userTry == "test123")) {
          return true;
      }
      
      return icheckSecurityImage($userTry);
    }


    return true;
  }


  /**
   * return true if for that user, captcha has to be resolved
   *
   * @return unknown
   */
  function isSecurityImageActive() {
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'config.securityimages.php');
    $user = JFactory::getUser();
    $log = JLog::getInstance();

    if (isset($user) && !$user->guest && $securityImagesLoggedInUserSwitchOff) {
      if ($securityImagesDebug) {
        $log->addEntry(JTEXT::_('LOG_REGISTERED_SI_OFF'));
      }
      return false;
    }

    if ($securitySwitchOffGlobally) {
      $log->addEntry(JTEXT::_('LOG_SI_OFF'));
      return false;
    }

    return true;
  }



  /**
   *
   * @author Walter Cedric
   * @return true if text entered by user is right or $securitySwitchOffGlobally = true
   */
  function checkSecurityImage($securityimage_try, $desiredSecurityImagesPlugins="", $desiredSecurityImagesPluginsVersion="") {

    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'config.securityimages.php');

    $securityImagesLet3rdpartyOverideChoosenPlugin = 0;
    #we delegate the check to the plugin checker code
    if ($securityImagesLet3rdpartyOverideChoosenPlugin) {
      include_once (JPATH_SITE.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'pluginsA'.DS.$desiredSecurityImagesPlugins.DS.$desiredSecurityImagesPluginsVersion.DS.'checker.php');
    }
    else
    {
      include_once (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'pluginsA'.DS.$securityImagesPlugins.DS.$securityImagesPluginsVersion.DS.'checker.php');
    }

    if ($this->isSecurityImageActive()) {
      return icheckSecurityImage($securityimage_refid, $securityimage_try, $securityimage_reload);
    }
  }

  /** public **/
  function getSecurityImageText($packageName) {
    if ($this->isSecurityImageActive()) {
      return getSecurityImageTextInternal($packageName);
    }
    return "";
  }

  /** public
   *
   * allow imput text to be always visible in admin area only
   *
   * **/
  function getSecurityImageText4AdminArea($packageName) {
    return getSecurityImageTextInternal($packageName);
  }

  /** private **/
  function getSecurityImageTextInternal($packageName) {
    //$text = "<a href=\"#\" " .
    //		"onMouseOver=\"return overlib('If yes, will show links to content to registered content even if you are not logged in.  The user will need to login to see the item in full.', BELOW, RIGHT);\" " .
    //		"onmouseout=\"return nd();\" >" .
    //		"<img src=\"".JPATH_SITE ."/includes/js/ThemeOffice/tooltip.png\" border=\"0\" /></a>";

    $insertStr = "<input name='" . $packageName . "_try' id='" . $packageName . "_try' class='inputbox' type='text' size='20' maxlength='10'>\n";
    $insertStr .= "<script type='text/javascript'>SecurityImagesInit();</script>";
    return $insertStr;
  }

  function getSecurityImageTextHeader() {
    if ($this->isSecurityImageActive()) {
      return JText::_('SECURITY IMAGES ENTER TEXT HEADER');
    }
    return "";
  }


  function getSecurityImageTextHelp() {
    if ($this->isSecurityImageActive()) {
      return JText::_('SECURITY IMAGES ENTER TEXT HELP');;
    }
    return "";
  }

  /**
   * package name should be an unique identifier for the form you want to protect
   *
   * this allow to have many form with captcha on the same page
   *
   */
  function getSecurityImageField($packageName) {
    $insertStr = "";
    if ($this->isSecurityImageActive()) {
      $insertStr = "<input name='" . $packageName . "_try' id='" . $packageName . "_try' class='inputbox' type='text' size='20' maxlength='10'>\n";
      $insertStr .= "<script type='text/javascript'>SecurityImagesInit();</script>";
    }
    return $insertStr;
  }

  /**
   *
   *
   * **/
  function echoSecurityImageText($packageName) {
    include(JPATH_SITE . DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'config.securityimages.php');

    if (!$securitySwitchOffGlobally) {
      echo $this->getSecurityImageText($packageName);
    }
    echo "";
  }

  /**
   * XXL size of core size picture
   *
   * needed in future for a zoom onHover() ????
   *
   * @public
   * @authors Walter Cedric
   */
  function insertXXLSecurityImage($packageName) {
    return $this->privateinsertSecurityImage($packageName, "","","");
  }

  /**
   * Large size of core size picture
   *
   * attention may not always be readable due to downsizing/upsizing!
   *
   * @public
   * @authors Walter Cedric
   */
  function insertLargeSecurityImage($packageName) {
    return $this->privateinsertSecurityImage($packageName, "200px","35px","L");
  }

  /**
   * Small size of core size picture, perfect for login for example
   *
   * attention may not always be readable due to downsizing/upsizing!
   *
   * @public
   * @authors Walter Cedric
   */
  function insertSmallSecurityImage($packageName) {
    return $this->privateinsertSecurityImage($packageName, "150px","30px", "S");
  }

  /**
   * For backward compatibilities, default size of core size picture
   *
   * @public
   * @authors Walter Cedric
   */
  function insertSecurityImage($packageName, $controllerURL) {
    return $this->privateinsertSecurityImage($packageName, "","","", $controllerURL);
  }

  /**
   * For backward compatibilities, default size of core size picture
   *
   * @public
   * @authors Walter Cedric
   */
  function insertXXLSecurityImage4AdminArea($packageName) {
    return $this->privateinsertSecurityImageInternal($packageName, "","","");
  }




  /**
   * Insert an image and some hidden field or nothing depending on value of $securitySwitchOffGlobally
   *
   * @private
   * @authors Walter Cedric
   */
  function privateinsertSecurityImage($packageName, $itswidth, $itsheight, $size, $controllerURL) {
    if ($this->isSecurityImageActive()) {
      return $this->privateinsertSecurityImageInternal($packageName, $itswidth, $itsheight, $size, $controllerURL);
    }
     
    return "";
  }




  /**
   * Insert an image and some hidden field or nothing depending on value of $securitySwitchOffGlobally
   *
   * @private
   * @authors Walter Cedric
   */
  function privateinsertSecurityImageInternal($packageName, $itswidth, $itsheight, $size, $controllerURL) {
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'config.securityimages.php');

    $securityImageSystemInfo = & new SecurityImageSystemInfo();
    if ($securityImageSystemInfo->isGDInstalled()) {
      //$image = "<img src='".JURI :: root()."index.php?option=com_securityimages&task=displayCaptchaByPlugin&plugin=".$pluginName."&version=".$pluginVersion."&refid=".$refid."&size=".$size."&sessionid=".$sessionid."' ";
      $image = "<img src='".$controllerURL."' ";
    } else {
      $image = "<b>PHP has not GD installed with true-type likage, only plugin working is freecap</b>";
    }
     
     
    if ($securityImagesDisplayAuthorBacklink) {
      $image = "<a href=\"http://www.waltercedric.com\">" .$image;
    }

    //insert javascript
    $insertstr  = "<script type='text/javascript' src='".JURI :: root()."/components/com_securityimages/js/securityImages.js"."'></script>";
    $insertstr .= "<link href='".JURI :: root()."/components/com_securityimages/securityimages.css' rel='stylesheet' type='text/css'/>";
    $insertstr .= $image;
    $insertstr .=" title='".JText::_('_SECURITY_IMAGES_ALT_GENERATED_IMAGE')."' alt='".JText::_('_SECURITY_IMAGES_ALT_GENERATED_IMAGE')."'";
    $insertstr .= " id='$packageName' name='$packageName' border='0'>";

    if ($securityImagesDisplayAuthorBacklink) {
      $insertstr .= "</a>";
    }

    //package name is given by user TODO in the furture remove try and reload, not needed, can be uuid! make debugging more difficult also
    $packageName_try = $packageName."_try";
     
    if ($securityImagesDeactivateReloadButton) {
      $insertstr .= "<a href=\"javascript:SecurityImagesNew('$packageName');\" id='askNewPicture' title='".JText::_('SECURITY_IMAGES_RELOAD_ALT')."' alt='".JText::_('SECURITY_IMAGES_RELOAD_ALT')."'>" .
	   					" <img src='".JURI :: root()."/components/com_securityimages/buttons/reload.gif' border='0'>" .
	   					"</a>";
    }
     
    if ($securityImagesDeactivateSoundButton)	{
      $insertstr .= "<a href='javascript:SecurityImagesNew();' id='askNewPicture' title='".JText::_('SECURITY IMAGES SOUND ALT')."' alt='"._SECURITY_IMAGES_SOUND_ALT."'>" .
	   					" <img src='".JURI :: root()."/components/com_securityimages/buttons/speaker.gif' border='0'>" .
	   					"</a>";
    }


    return $insertstr;
  }


  function showLogsFile($option) {
    $logsLocation = JPATH_SITE .DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'logs'.DS.'security.txt';
    require_once(dirname( __FILE__ ).DS.'config.php');

    if (file_exists($logsLocation)) {
      $file = $logsLocation;
    }
    @ chmod($file, 0766);
    $permission = is_writable($file);
    if (!$permission) {
      echo "<center><h1><font color=red>Warning...</FONT></h1></br>";
      echo "<B>You need to chmod the file to 766 in order to save your updates.</B></center><BR />";
    }
    $SecurityImagesConfig = & new SecurityImagesConfig();
    $SecurityImagesConfig->showFile($file, $option);
  }

  /**
   * Enter description here...
   *
   * @param unknown_type $securityImagesVersion
   * @param unknown_type $securityImagesLink
   * @return unknown
   */
  function getMainCopyright($securityImagesVersion, $securityImagesLink) {
    $copyright = "/** ****************************************************************\n";
    $copyright .= "* This file is part of SecurityImages for Joomla!.\n";
    $copyright .= "*\n";
    $copyright .= "* SecurityImages is free software: you can redistribute it and/or modify\n";
    $copyright .= "* it under the terms of the GNU General Public License as published by\n";
    $copyright .= "* any later version.\n";

    $copyright .= "* Foobar is distributed in the hope that it will be useful,\n";
    $copyright .= "*but WITHOUT ANY WARRANTY; without even the implied warranty of\n";
    $copyright .= "* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the\n";
    $copyright .= "* GNU General Public License for more details.\n";
    $copyright .= "*\n";
    $copyright .= "* You should have received a copy of the GNU General Public License\n";
    $copyright .= "* along with Foobar.  If not, see <http://www.gnu.org/licenses/>.\n";
    $copyright .= "*\n";
    $copyright .= "* @package		SecurityImages\n";
    $copyright .= "* @copyright	Copyright (C) 2004 - 2008 Cdric Walter. All rights reserved.\n";
    $copyright .= "********************************************************************/\n";


    return $copyright;
  }


}
?>