<?php
/**
 * Main File
 *
 * @package    Modalizer
 * @version    1.2.3
 * @since      File available since Release 1.0.0
 *
 * @author     Peter van Westen <peter@nonumber.nl>
 * @link       http://www.nonumber.nl/modalizer
 * @copyright  Copyright (C) 2008 NoNumber! All Rights Reserved
 * @license    http://www.gnu.org/licenses/gpl-2.0.html GNU/GPL
 */

// Ensure this file is being included by a parent file
defined( '_JEXEC' ) or die( 'Restricted access' );

// Import library dependencies
jimport( 'joomla.event.plugin' );

// Include the syndicate functions only once
require_once( dirname( __FILE__ ).DS.'modalizer'.DS.'helper.php' );
require_once( dirname( __FILE__ ).DS.'modalizer'.DS.'elements'.DS.'version_check.php' );

/**
* Plugin that makes links (with a target=_blank) open in a Modal Window
*/
class plgSystemModalizer extends JPlugin {
	/**
	* Constructor
	*
	* For php4 compatability we must not use the __constructor as a constructor for
	* plugins because func_get_args ( void ) returns a copy of all passed arguments
	* NOT references.  This causes problems with cross-referencing necessary for the
	* observer design pattern.
	*/
	function plgSystemModalizer( &$subject )
	{
		parent::__construct( $subject );

		// load plugin parameters
		$this->_plugin = JPluginHelper::getPlugin( 'system', 'modalizer' );
		$this->_params = new JParameter( $this->_plugin->params );

		// Put all plugin parameters into a global variable
		$this->params = plgSystemModalizerHelper::returnParams( $this->_params );
	}

	function onAfterInitialise()
	{
		global $mainframe;

		if ( !$this->params['allow_plugin'] ) { return; }

		// set the main template
		if ( $this->params['set_maintemplate'] ) $mainframe->setTemplate( $this->params['set_maintemplate'] );

		// include the modal scripts (if page is not a modal window)
		if ( !$this->params['is_modalwindow'] && $this->params['inc_mootools'] ) {
			JHTML::_('behavior.mootools');
		}

		return true;
	}

	function onAfterDispatch()
	{
		// Only do stuff in the non-html pages (like pdf) and in the Modalizer Admin page
		// Te rest is done in the onAfterRender
		if ( ( $this->params['allow_plugin'] && $this->params['is_admin'] ) || $this->params['doctype'] != 'html' ) {
			$_document	=& JFactory::getDocument();

			// Only if buffer is set
			if ( $_document->getBuffer( 'component' ) ) {

				// Replace the Modal list items with modal syntax links
				// Only done in the form of the Admin of Modalizer
				if ( $this->params['is_admin'] ) {
					$_regex_form = '#<form [^>]*name="adminForm".*?</form>#si';
					preg_match( $_regex_form, $_document->getBuffer( 'component' ), $_form_part );
					$_regex_label = '#(<label for="paramstype([^"]+?)">)([^<]+).*?(<br />\s*</label>)#si';
					$_r = '\1\3 {modal type=\2|link=../plugins/system/modalizer/modals/testpage.html}Example{/modal}\4';
					// Replace stuff in the labels with ther Modalizer syntax
					$_new_form_part = preg_replace( $_regex_label, $_r, $_form_part[0] );
					// Convert Modalizer syntax tags
					$_new_form_part = plgSystemModalizerHelper::convertModalSyntax( $_new_form_part );
					$_document->setBuffer( str_replace( $_form_part, $_new_form_part, $_document->getBuffer( 'component' ) ), 'component' );
				} else {
					// Convert Modalizer syntax tags
					$_document->setBuffer( plgSystemModalizerHelper::convertModalSyntax( $_document->getBuffer( 'component' ) ), 'component' );
				}
			}

			// Convert Modalizer syntax tags in Feed items
			if ( $this->params['doctype'] == 'feed' ) {
				$_count = count( $_document->items );
				for ( $_i = 0; $_i < $_count; $_i++ ) {
					$_document->items[$_i]->description = plgSystemModalizerHelper::convertModalSyntax( $_document->items[$_i]->description );
				}
			}
		}
	}

	function onAfterRender()
	{
		// Return if page is not html
		if ( $this->params['doctype'] != 'html' ) { return; }

		$_body = JResponse::getBody();

		// Show update icon
		if ( $this->params['is_admin'] && $this->_params->get( 'show_update', 1 ) ) {
				$_lang =& JFactory::getLanguage();
				$_lang->load('plg_system_modalizer');
				$_body = ModalizerVersionCheck::setIcon( $_body, 'version_modalizer', '', 'http://www.nonumber.nl/versions', 'http://www.nonumber.nl/download/modalizer', '../plugins/system/modalizer/images/icon-ani.gif' );
						JResponse::setBody( $_body );
					}

		// Return if plugin is not allowed here
		if ( !$this->params['allow_plugin'] ) { return; }

		// protect editor form area
		if ( JRequest::getCmd( 'task' ) == 'edit' ) {
			$_search_regex = '(<form [^>]*name="adminform".*?>.+?</form>)';
			$_search_regex = '#'.$_search_regex.'#si';
			$_body = preg_replace( $_search_regex, $this->params['protect_start'].'\1'.$this->params['protect_end'], $_body );
			$_body = plgSystemModalizerHelper::stringProtectorForward( $_body );
		}

		// Only where modals are allowed to be made
		if ( $this->params['allow_modals'] ) {
			// Modalize links
			$_body = plgSystemModalizerHelper::modalizeLinks( $_body );
		}

		// Convert Modalizer Sytax Tags
		if ( $this->params['enable_modal_syntax'] ) {
			$_body = plgSystemModalizerHelper::convertModalSyntax( $_body );
		}
		
		$_body = plgSystemModalizerHelper::stringProtectorReverse( $_body );

		// Only in the modal window
		if ( $this->params['is_modalwindow'] ) {
			// Remove tags with window.close in it
			$_body = plgSystemModalizerHelper::changeTagsByContent( $_body, 'window.close(' );

			// Add the templates to internal links
			$_body = plgSystemModalizerHelper::changeUrlByTagname( $_body, 'a', 'href' );

			// Add the templates to forms actions
			$_body = plgSystemModalizerHelper::changeUrlByTagname( $_body, 'form', 'action' );
		}

		// Final Only where modals are allowed to be made
		if ( $this->params['allow_modals'] || $this->params['is_admin'] ) {
			// Place the necessary scripts
			$_body = plgSystemModalizerHelper::placeModalScripts( $_body );
		}

		if ( $_body ) {
			JResponse::setBody( $_body );
		}

		return true;
	}
}