<?php
/** ****************************************************************
 * This file is part of SecurityImages for Joomla!.
 *
 * SecurityImages is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.

 * Foobar is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with Foobar.  If not, see <http://www.gnu.org/licenses/>.
 *
 * @package		SecurityImages
 * @copyright	Copyright (C) 2004 - 2008 Cdric Walter. All rights reserved.
 *******************************************************************/

defined( '_JEXEC' ) or die( 'Restricted access' );

JLoader::import('securityImagesLogsDao', dirname( __FILE__ ));

class LogUtils extends JObject {

  var $mosSecurityCommentLogs = null;

  function LogUtils() {
    $database = & JFactory::getDBO();
    $this->mosSecurityCommentLogs = & new mosSecurityCommentLogs($database);
  }


  function isAnEmail($email) {
    $rBool = false;
    if (preg_match("/[\w\.\-]+@\w+[\w\.\-]*?\.\w{1,4}/", $email)) {
      $rBool = true;
    }
    return $rBool;
  }

  /**
   * public
   */
  function writeCommentLog($acceptPost) {
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'config.securityimages.php');

    if (($securityImagesLogActive && !$acceptPost) || $securityImagesLogAll) {
      $this->iWriteCommentLog($acceptPost);
    }
  }


  /**
   * private
   */
  function iWriteCommentLog($acceptPost, $text = "") {
    $database = & JFactory::getDBO();
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'config.securityimages.php');
     
    if (!$securityImagesLogActive) {
      return;
    }
    # Clear any HTML and SQL injections
    $text = strip_tags($text);
    $text = mysql_escape_string($text);
    $date = date("Y-m-d H:i:s");
    $remoteServer = getenv('REMOTE_ADDR');
    $userAgent = getenv('HTTP_USER_AGENT');
    $referer = getenv('HTTP_REFERER');
    $itemid = getenv('contentid');

    $query2 = "INSERT INTO #__security_images_logs "."SET wasAccepted='$acceptPost', "."insertDate='$date',"."remoteServer='$remoteServer', "."userAgent='$userAgent', "."referer='$referer', "."text='$text',"."itemid='$itemid';";
    $database->setQuery($query2);
    $database->query();

    $database->setQuery( "SELECT count(*) FROM #__security_images_logs");
    $spamCount = $database->loadResult();
    if ($spamCount > $securityImagesLogSize) {
      $this->sendMailLogsToAdmin($this->getHTMLtable());
    }
  }
  /**
   * Send an html report history by email
   *
   *
   */
  function sendMailLogsToAdmin($content) {
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'config.securityimages.php');

    if ($securityImagesNotifyAdmin AND $this->isAnEmail($securityImagesAdminEmail)) {
      mail($securityImagesAdminEmail, _HASHCASH_ADMINMAILHEADER, $content, "From: ".$securityImagesAdminEmail);
    }

  }

  function getHTMLtable() {
    include (JPATH_SITE.DS.'administrator'.DS.'components'.DS.'com_securityimages'.DS.'config.securityimages.php');

    $header = "<html><head><style>tr { margin: 0px 0px 5px 20px; }</style></head><body><h2>Spam Report:</h2>";
    $footer = "</body></html>";
    $i = false;

    $content = "<table>";
    $content .= "<th>".$this->getHTMLHeader()."</th>";

    $database = & JFactory::getDBO();
    $database->setQuery( "SELECT * FROM #__security_images_logs");
    $rows = $database->loadObjectList();
    for ($i=0, $n=count( $rows ); $i < $n; $i++) {
      $row = &$rows[$i];
      if ($i) {
        $content .= '<tr style="background-color: #eee">';
      } else {
        $content .= '<tr>';
      }
      $content .= "<td align='center'>$row->id</td>";
      $res = $row->wasAccepted ? 'Yes' : 'No';
      $content .= "<td align='center'>$res</td>";
      $content .= "<td align='center'>$row->insertDate</td>";
      $content .= "<td align='center'>$row->remoteServer</td>";
      $content .= "<td align='center'>$row->userAgent</td>";
      $content .= "<td align='center'>$row->referer</td>";
      $content .= "<td align='left'>$row->text</td>";
      $content .= "<td align='center'>$row->itemid</td>";
      $content .= "</tr>";
      $i = !$i;
    }
    $content .= "</table>";
    $content .= $footer;
    return $content;
  }

  function getHTMLHeader() {
    $content = "<td><strong>ID:</strong></td>";
    $content .= "<td><strong>Accepted:</strong></td>";
    $content .= "<td><strong>Date:</strong></td>";
    $content .= "<td><strong>IP:</strong></td>";
    $content .= "<td><strong>UserAgent:</strong></td>";
    $content .= "<td><strong>Referer:</strong></td>";
    $content .= "<td><strong>Text:</strong></td>";
    $content .= "<td><strong>Itemid:</strong></td>";
    return $content;
  }


  /**
   *
   * @author Walter Cedric www.waltercedric.com
   */
  function emptyLogs() {
    $database = & JFactory::getDBO();
    $database->setQuery("delete FROM #__security_images_logs");
    $database->query();
  }

  /**
   *
   * @author Walter Cedric www.waltercedric.com
   */
  function exportToCSV() {
    $rowsVector = $this->mosSecurityCommentLogs->getRowsVector();
    $csvResult = "";
    $SEPARATOR = ";";
    for ($i = 0, $n = count($rowsVector); $i < $n; $i ++) {
      $arow = & $rowsVector[$i];
      $csvResult .= "".$arow->wasAccepted.$SEPARATOR.$arow->insertDate.$SEPARATOR.$arow->userAgent.$SEPARATOR.$arow->referer.$SEPARATOR.$arow->text.$SEPARATOR.$arow->itemid.$SEPARATOR;
      $csvResult .= "\n";
    }

    $this->streamToClient($csvResult, "SecurityImage.txt");
  }

  /**
   *
   * @author Walter Cedric www.waltercedric.com
   */
  function exportToHTML() {
    $rowsVector = $this->mosSecurityCommentLogs->getRowsVector();
    $htmlResult = "";
    //I want a XMLWriter helper :-)
    $htmlResult .= "<html><title></title>"."<head></head><body>";

    //TODO improve title!
    $htmlResult .= "<h2>Security Images logs</h2>";
    $htmlResult .= "<table border='1'>";

    $htmlResult .= "<th>Id</th>"."<th>Accepted</th>"."<th>Insertdate</th>"."<th>UserAgent</th>"."<th>Referer</th>"."<th>Text</th>"."<th>Itemid</th>";
    for ($i = 0, $n = count($rowsVector); $i < $n; $i ++) {
      $arow = & $rowsVector[$i];
      $htmlResult .= '<tr><td>&nbsp;'.$arow->id.'</td>';
      $htmlResult .= '<td>&nbsp;'.$arow->wasAccepted.'</td>';
      $htmlResult .= '<td>&nbsp;'.$arow->insertDate.'</td>';
      $htmlResult .= '<td>&nbsp;'.$arow->userAgent.'</td>';
      $htmlResult .= '<td>&nbsp;'.$arow->referer.'</td>';
      $htmlResult .= '<td>&nbsp;'.$arow->text.'</td>';
      $htmlResult .= '<td>&nbsp;'.$arow->itemid.'</td>';
      $htmlResult .= '<tr>';
    }
    $htmlResult .= '<table><body><html>';

    $this->streamToClient($htmlResult, "SecurityImage.html");
  }

  /**
   *
   * @author Walter Cedric www.waltercedric.com
   */
  function exportToXML() {
    $rowsVector = $this->mosSecurityCommentLogs->getRowsVector();
    $xmlResult = null;

    //I want a XMLWriter helper :-)
    $xmlResult .= '<?xml version="1.0" encoding="UTF-8"?><SecurityImagesLogs>';
    for ($i = 0, $n = count($rowsVector); $i < $n; $i ++) {
      $arow = & $rowsVector[$i];
      $xmlResult .= '<Entry><Id>'.$arow->id.'</Id>';
      $xmlResult .= '<Accepted>'.$arow->wasAccepted.'</Accepted>';
      $xmlResult .= '<Insertdate>'.$arow->insertDate.'</Insertdate>';
      $xmlResult .= '<UserAgent>'.$this->xmlentities($arow->userAgent).'</UserAgent>';
      $xmlResult .= '<Referer>'.$this->xmlentities($arow->referer).'</Referer>';
      $xmlResult .= '<Text>'.$this->xmlentities($arow->text).'</Text>';
      $xmlResult .= '<Itemid>'.$arow->itemid.'</Itemid>';
      $xmlResult .= '</Entry>';
    }
    $xmlResult .= '</SecurityImagesLogs>';
    $this->streamToClient($xmlResult, "SecurityImage.xml");
  }

  /*function xmlentities($string) {
   return str_replace(array ('&', '"', "'", '<', '>'), array ('&amp;', '&quot;', '&apos;', '&lt;', '&gt;'), $string);
   }*/

  /**
   * code take from http://fr2.php.net/manual/en/function.htmlentities.php
   *
   */
  function xmlentities($string, $quote_style = ENT_QUOTES) {
    static $trans;
    if (!isset ($trans)) {
      $trans = get_html_translation_table(HTML_ENTITIES, $quote_style);
      foreach ($trans as $key => $value)
      $trans[$key] = '&#'.ord($key).';';
      // dont translate the '&' in case it is part of &xxx;
      $trans[chr(38)] = '&';
    }
    // after the initial translation, _do_ map standalone '&' into '&#38;'
    return preg_replace("/&(?![A-Za-z]{0,4}\w{2,3};|#[0-9]{2,3};)/", "&#38;", strtr($string, $trans));
  }

  /**
   * 	//header("content-type: text/plain");
   */
  function streamToClient($content, $downloadName) {

    header("Content-Type: application/force-download");
    header("Content-disposition: attachment; filename=$downloadName");
    header("Content-Transfer-Encoding: binary");
    header("Content-Length: ".strlen($content));
    header("Pragma: no-cache");
    header("Connection: close");
    header("Expires: 0");
    ob_start(); //buffering on server
    print $content;
    ob_end_flush();
  }

  function showLogs($option) {
    global $mainframe;

    $database = & JFactory::getDBO();

    $limit = $mainframe->getUserStateFromRequest("viewlistlimit", 'limit', 10);
    $limitstart = $mainframe->getUserStateFromRequest("view{$option}limitstart", 'limitstart', 0);
    $search = $mainframe->getUserStateFromRequest("search{$option}", 'search', '');
    $search = $database->getEscaped(trim(strtolower($search)));

    $where = array ();
    if ($search) {
      $where[] = "LOWER(text) LIKE '%$search%'";
    }

    $database->setQuery("SELECT count(*) FROM #__security_images_logs "."AS a". (count($where) ? " WHERE ".implode(' AND ', $where) : ""));
    $total = $database->loadResult();
    echo $database->getErrorMsg();
    include_once ("includes/pageNavigation.php");
    $pageNav = new mosPageNav($total, $limitstart, $limit);

    $database->setQuery("SELECT * FROM #__security_images_logs". (count($where) ? "\nWHERE ".implode(' AND ', $where) : "")."\nORDER BY id DESC"."\nLIMIT $pageNav->limitstart,$pageNav->limit");
    $rows = $database->loadObjectList();
    if ($database->getErrorNum()) {
      echo $database->stderr();
      return false;
    }

    $this->showSpamLogs($option, $rows, $search, $pageNav);
  }

  function showSpamLogs($option, & $rows, & $search, & $pageNav) {
    //global JURL_SITE;
    $commentlenght = "40";
    # Table header
    ?>

<!-- for onHOver links -->
<script language="JavaScript"
	src="<?php echo JURL_SITE ?>/includes/js/overlib_mini.js"
	type="text/javascript"></script>

<form action="index2.php" method="post" name="adminForm">
<table cellpadding="4" cellspacing="0" border="0" width="100%">
	<tr>
		<td width="100%"><img
			src="components/com_securityimages/logo/securityImage_logosmall.png">
		</td>
		<td align="left" valign="middle"><strong><?php echo JText::_('SECURITY IMAGES EXPORT') ?>&nbsp;</strong></td>
		<td align="left" valign="middle"><input type="submit"
			value="<?php echo JText::_('SECURITY IMAGES EXPORT CSV') ?>"
			onclick="javascript:submitbutton('exportToCSV');"></td>
		<td align="left" valign="middle"><input type="submit"
			value="<?php echo JText::_('SECURITY IMAGES EXPORT HTML') ?>"
			onclick="javascript:submitbutton('exportToHTML');"></td>
		<td align="left" valign="middle"><input type="submit"
			value="<?php echo JText::_('SECURITY IMAGES EXPORT XML') ?>"
			onclick="javascript:submitbutton('exportToXML');"></td>
		<td align="left" valign="middle">&nbsp;&nbsp;&nbsp;&nbsp;</td>
		<td align="left" valign="middle"><input type="submit"
			value="<?php echo JText::_('SECURITY IMAGES EMPTY LOGS') ?>"
			onclick="javascript:submitbutton('deleteSecurityImagesLogs');"></td>

		<td nowrap="nowrap">Display #</td>
		<td><?php echo $pageNav->writeLimitBox(); ?></td>
		<td>Search:</td>
		<td><input type="text" name="search" value="<?php echo $search;?>"
			class="inputbox" onChange="document.adminForm.submit();" /></td>
	</tr>
</table>
<table cellpadding="4" cellspacing="0" border="0" width="100%"
	class="adminlist">
	<tr>
		<th class="title">
		<div align="center"><?php echo JText::_('ID') ?></div>
		</th>
		<th class="title">
		<div align="left"><?php echo JText::_('Accepted') ?></div>
		</th>
		<th class="title">
		<div align="center"><?php echo JText::_('Date') ?></div>
		</th>
		<th class="title">
		<div align="center"><?php echo JText::_('IP') ?></div>
		</th>
		<th class="title">
		<div align="center"><?php echo JText::_('UserAgent') ?></div>
		</th>
		<th class="title">
		<div align="center"><?php echo JText::_('Referer') ?></div>
		</th>
		<th class="title">
		<div align="center"><?php echo JText::_('Text') ?></div>
		</th>
		<th class="title">
		<div align="center"><?php echo JText::_('Itemid') ?></div>
		</th>
	</tr>
	<tr>
	<?php


	$k = 0;
	for ($i = 0, $n = count($rows); $i < $n; $i ++) {
			$row = & $rows[$i];
			echo "<tr class='row$k'>";
			echo "<td align='center'>$row->id</td>";

			$img = $row->wasAccepted ? 'tick.png' : 'publish_x.png';
			echo "<td align='center'><img src='".JURL_SITE."/administrator/images/$img'></td>";

			echo "<td align='center'>$row->insertDate</td>";
			echo "<td align='center'>$row->remoteServer</td>";
			echo "<td align='center'>$row->userAgent</td>";
			echo "<td align='center'>$row->referer</td>";
			$truncateText = $row->text;
			if (strlen($row->text) > $commentlenght) {
			  $truncateText = substr($row->text, 0, $entrylenght -3);
			  $truncateText .= "...";
			}
			echo "<td align='left'>"."<a href='#' onmouseover=\"return overlib('$row->text', BELOW, RIGHT);\" onmouseout=\"return nd();\">".$truncateText."</a>"."</td>";

			echo "<td align='center'>$row->itemid</td>";
			?>
	</tr>
	<?php $k = 1 - $k; } ?>
	<tr>
		<th align="center" colspan="8"><?php echo $pageNav->writePagesLinks(); ?></th>
	</tr>
	<tr>
		<td align="center" colspan="8"><?php echo $pageNav->writePagesCounter(); ?></td>
	</tr>
</table>
<input type="hidden" name="option" value="<?php echo $option;?>" /> <input
	type="hidden" name="task" value="" /> <input type="hidden"
	name="boxchecked" value="0" /></form>
	<?php


}

}
?>